(setf *unexploded-seven-values* *seven-values*)



(defun implode-desktop ()
  (let ((7v *seven-values*))
    (default-desktop *unexploded-seven-values*)
    (default-desktop)
    (apply #'set-seven-values 7v))
  (setf *exploded-desktop* nil)
  (send *explode-desktop-menu-item* :title "Explode DeskTop")
  *unexploded-seven-values*)


(defun explode-desktop ()
  (if *exploded-desktop* (implode-the-desktop) (explode-the-desktop))
  *exploded-desktop*)
  
(defun implode-the-desktop ()
  (send *desktop-container* :make-desktop-container-resize )
  (default-desktop)
  ;(repair-seven-values)
  (default-desktop *unexploded-seven-values*)
  (setf *exploded-desktop* nil)
  (send *desktop-container* :change-desktop-menu nil)
  *exploded-desktop*)


(defun explode-the-desktop ()
  (restore-layout)
  (setf *unexploded-seven-values* (seven-desktop-values))
  (setf *exploded-menubar* *desktop-container*)
  (send *exploded-menubar* :top-most t)
  (send *exploded-menubar* :bottom-most nil)
  (mapcar #'(lambda (window)
              (send window :no-move nil)
              (apply #'send window :frame-location 
                     (+ '(-4 24) 
                        (send *exploded-menubar* :frame-location) 
                        (send window :location)))
              (send window :pop-out t)
              ;(send window :front-window)
              )
          (list *workmap* *selector* ))
  (send *selector* :frame-location 
        (+ 4 (first (send *selector* :frame-location)))
        (second (send *selector* :frame-location)))
  (send *selector* :frame-size 
        (+ 2 (first (send *selector* :frame-size)))
        (second (send *selector* :frame-size)))
  (send *listener* :no-move nil)
  (apply #'send *listener* :frame-location 
         (+ (send *listener* :frame-location) '(-4 24)
            (send *desktop-container* :location)))
  (defmeth *exploded-menubar* :resize () 
    (send *exploded-menubar* :size 
          (first (send *exploded-menubar* :size)) 16))
  (send *listener* :pop-out t)
  (send *exploded-menubar* :resize)
  (send *exploded-menubar* :top-most NIL)
  (setf *exploded-desktop* t)
  (send *desktop-container* :change-desktop-menu t)
  )


(defmeth container-proto :change-desktop-menu (exploded-desktop)
  (unless *desktop-menubar-menu-items*
          (setf *desktop-menubar-menu-items*
                (send *desktop-desktop-menu* :items)))
  (unless *exploded-desktop-menubar-menu-items*
          (setf *exploded-desktop-menubar-menu-items*
                (list (send expert-menu-item-proto :new "Show WorkMap" :enabled t
                            :action #'(lambda () (send *workmap* :front-window)))
                      (send expert-menu-item-proto :new "Show Selector" :enabled t
                            :action #'(lambda () (send *varobs-obj* :front-window)))
                      (send expert-menu-item-proto :new "Show Listener" :enabled t
                            :action #'(lambda () (send *listener* :front-window))))))
  (apply #'send *desktop-desktop-menu* :delete-items 
         (send *desktop-desktop-menu* :items))
  (cond 
    (exploded-desktop
     (apply #'send *desktop-desktop-menu* :append-items
            (combine *exploded-desktop-menubar-menu-items*
                     (select *desktop-menubar-menu-items* 
                             (iseq 3 (1- (length *desktop-menubar-menu-items* )))))))
    (t
     (apply #'send *desktop-desktop-menu* :append-items
            *desktop-menubar-menu-items*)))
  
  (send *explode-desktop-menu-item* :title 
        (if exploded-desktop "Implode DeskTop" "Explode DeskTop"))
  t)

